/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.metalbarrels.tile;

import com.tfar.metalbarrels.block.MetalBarrelBlock;
import com.tfar.metalbarrels.util.MetalBarrelBlockEntityType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class MetalBarrelBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    protected final int width;
    protected final int height;
    protected final PropertyDispatch.TriFunction<Integer, Inventory, ContainerLevelAccess, AbstractContainerMenu> containerFactory;
    protected Component customName;
    public final LazyOptional<IItemHandler> optional;
    public final ItemStackHandler handler;
    public int players = 0;

    public MetalBarrelBlockEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.width = ((MetalBarrelBlockEntityType)tileEntityType).width;
        this.height = ((MetalBarrelBlockEntityType)tileEntityType).height;
        this.containerFactory = ((MetalBarrelBlockEntityType)tileEntityType).containerFactory;
        this.handler = new ItemStackHandler(this.width * this.height){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                MetalBarrelBlockEntity.this.m_6596_();
            }
        };
        this.optional = LazyOptional.of(() -> this.handler);
    }

    public void m_183515_(CompoundTag tag) {
        CompoundTag compound = this.handler.serializeNBT();
        tag.m_128365_("inv", (Tag)compound);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        super.m_183515_(tag);
    }

    public void changeState(BlockState p_213963_1_, boolean p_213963_2_) {
        if (p_213963_1_.m_60734_() instanceof MetalBarrelBlock) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)p_213963_1_.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(p_213963_2_)), 3);
        }
    }

    public void soundStuff(BlockState p_213965_1_, SoundEvent p_213965_2_) {
        if (!(p_213965_1_.m_60734_() instanceof MetalBarrelBlock)) {
            return;
        }
        Vec3i lvt_3_1_ = ((Direction)p_213965_1_.m_61143_((Property)BarrelBlock.f_49042_)).m_122436_();
        double lvt_4_1_ = (double)this.f_58858_.m_123341_() + 0.5 + (double)lvt_3_1_.m_123341_() / 2.0;
        double lvt_6_1_ = (double)this.f_58858_.m_123342_() + 0.5 + (double)lvt_3_1_.m_123342_() / 2.0;
        double lvt_8_1_ = (double)this.f_58858_.m_123343_() + 0.5 + (double)lvt_3_1_.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, lvt_4_1_, lvt_6_1_, lvt_8_1_, p_213965_2_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
    }

    public void m_142466_(CompoundTag tag) {
        CompoundTag invTag = tag.m_128469_("inv");
        this.handler.deserializeNBT(invTag);
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        super.m_142466_(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.optional.cast() : super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.optional.invalidate();
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    protected Component getDefaultName() {
        return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return (AbstractContainerMenu)this.containerFactory.m_125475_((Object)id, (Object)inv, (Object)ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
    }
}

